package buffered_logger

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/service/cloudwatchlogs"
)

func (hook *CWLogHook) getCWLogGroup() error {
	resp, err := hook.client.DescribeLogStreams(&cloudwatchlogs.DescribeLogStreamsInput{
		LogGroupName:        aws.String(hook.identifier.Group),
		LogStreamNamePrefix: aws.String(hook.identifier.Stream),
		Limit:               aws.Int64(1),
	})

	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloudwatchlogs.ErrCodeResourceNotFoundException:
				return aerr
			default:
				return err
			}
		} else {
			return err
		}
	}

	if len(resp.LogStreams) > 0 {
		hook.nextSequenceToken = resp.LogStreams[0].UploadSequenceToken
	}

	return nil
}
