package buffered_logger

import (
	"github.com/aws/aws-sdk-go/service/cloudwatchlogs"
)

func (hook *CWLogHook) processLogEvent(cwEvent cloudwatchlogs.InputLogEvent) {
	hook.lock.Lock()
	defer hook.lock.Unlock()

	messageSize := len(*cwEvent.Message) + 26
	hook.batch.size += messageSize
	hook.batch.events = append(hook.batch.events, &cwEvent)
}
