package buffered_logger

import (
	"time"
)

func (hook *CWLogHook) runWorkToBeDone() {
	go func() {
		ticker := time.NewTicker(hook.bufferPeriod)
		defer ticker.Stop()

		for {
			select {
			case logEvent := <-hook.buffer:
				if !hook.validate(logEvent) {
					go hook.sendToCW()
				} else {
					hook.processLogEvent(logEvent)
				}
				go hook.sendToCW()
			case <-hook.closeSignal:
				hook.sendToCW()
				return
			}
		}
	}()
}
