package buffered_logger

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/cloudwatchlogs"
)

func (hook *CWLogHook) sendToCW() {
	hook.lock.Lock()
	defer hook.lock.Unlock()

	if hook.batch.size == 0 {
		return
	}

	params := &cloudwatchlogs.PutLogEventsInput{
		LogEvents:     hook.batch.events,
		LogGroupName:  aws.String(hook.identifier.Group),
		LogStreamName: aws.String(hook.identifier.Stream),
		SequenceToken: hook.nextSequenceToken,
	}

	resp, err := hook.client.PutLogEvents(params)
	if err != nil {
		// Simply log failed events out to desired logger
		hook.logDroppedEvents(err)
	} else {
		hook.nextSequenceToken = resp.NextSequenceToken
	}

	hook.cleanUp()
	return
}
