package buffered_logger

import "github.com/aws/aws-sdk-go/service/cloudwatchlogs"

func (hook *CWLogHook) validate(logEvent cloudwatchlogs.InputLogEvent) bool {
	// The maximum batch size of a PutLogEvents request is 1MB.
	messageSize := len(*logEvent.Message) + 26
	if hook.batch.size+messageSize >= 1048576 {
		hook.logger.Log("message size exceed Cloudwatch payload limit")
		return false
	}
	return true
}
