import { ISecret, Secret } from '@aws-cdk/aws-secretsmanager';
import { Construct, Stack, StackProps } from '@aws-cdk/core';

/**
 * Contains secrets specific to the Ingest Service
 */
export class ConfigServiceSecretsStack extends Stack {
  public readonly datadog: ISecret;
  public readonly pdmsLambdaClientSecret: ISecret; // used for app auth with OWL

  constructor(scope: Construct, name: string, props: StackProps) {
    super(scope, name, props);

    this.datadog = new Secret(this, 'DatadogSecret');
    this.pdmsLambdaClientSecret = new Secret(this, 'PDMSLambdaClientSecret');
  }
}
