import cfn = require('@aws-cdk/aws-cloudformation');
import cdk = require('@aws-cdk/core');

const EventBusTplURL = 'https://eventbus-setup.s3-us-west-2.amazonaws.com/cloudformation_v1.1.0.yaml';

/**
 * EventBus CloudFormation template.
 * It would be nice if they could provide a CDK construct, but for now we can wrap it as a nested stack.
 * https://git-aws.internal.justin.tv/pages/eventbus/docs/getting_started/
 */
export class EventBusStack extends cdk.Stack {
  constructor(scope: cdk.Construct, name: string, props: cdk.StackProps) {
    super(scope, name, props);

    // CfnStack will apply the template as a Nested Stack in CloudFormation
    new cfn.CfnStack(this, 'EventBusTemplate', {
      templateUrl: EventBusTplURL,
    });
  }

  //
  // Template Outputs can be accessed with Fn::ImportValue using they Export name.
  //

  public accessPolicyARN(): string {
    return cdk.Fn.importValue('eventbus-access-policy-arn');
  }

  public kmsMasterKeyARN(): string {
    return cdk.Fn.importValue('eventbus-kms-master-key-arn');
  }

  public sqsPolicyDocument(): string {
    return cdk.Fn.importValue('eventbus-sqs-policy-document');
  }
}
