import ec2 = require('@aws-cdk/aws-ec2');
import cdk = require('@aws-cdk/core');
import easymode = require('@twitch-easymode/privatelink-endpoint');

export interface InterfaceVpcEndpointStackProps extends cdk.StackProps {
  vpc: ec2.IVpc;
  service: ec2.IInterfaceVpcEndpointService;
  domainName: string; // DNS hostname, should be the same as the origin service.
}

export class InterfaceVpcEndpointStack extends cdk.Stack {
  constructor(scope: cdk.Construct, name: string, props: InterfaceVpcEndpointStackProps) {
    super(scope, name, props);

    const endpoint = new easymode.PrivateLinkEndpoint(this, 'Endpoint', {
      vpc: props.vpc,
      service: props.service,
      hostedZones: [{ zoneName: props.domainName }],
    });

    // Allow traffic only on the service port
    const port = props.service.port;
    endpoint.connections.allowFromAnyIpv4(
      new ec2.Port({
        stringRepresentation: port.toString(),
        protocol: ec2.Protocol.TCP,
        fromPort: port,
        toPort: port,
      })
    );
  }
}
