import { Bucket, IBucket } from '@aws-cdk/aws-s3';
import { Construct, RemovalPolicy, Stack, StackProps } from '@aws-cdk/core';

export class S3BucketStack extends Stack {
  public bucket: IBucket;

  constructor(scope: Construct, id: string, props: StackProps) {
    super(scope, id, props);

    this.bucket = new Bucket(this, 'S3Bucket', {
      removalPolicy: RemovalPolicy.DESTROY,
    });
  }
}
