import sns = require('@aws-cdk/aws-sns');
import subs = require('@aws-cdk/aws-sns-subscriptions');
import cdk = require('@aws-cdk/core');

interface SnsPagerdutyStackProps extends cdk.StackProps {
  highUrgencyUrl: string;
  lowUrgencyUrl: string;
}

export class SnsPagerdutyStack extends cdk.Stack {
  public highUrgencyTopic: sns.ITopic;
  public lowUrgencyTopic: sns.ITopic;

  constructor(scope: cdk.Construct, name: string, props: SnsPagerdutyStackProps) {
    super(scope, name, props);

    this.highUrgencyTopic = new sns.Topic(this, 'HighUrgencyTopic');
    this.highUrgencyTopic.addSubscription(new subs.UrlSubscription(props.highUrgencyUrl));

    this.lowUrgencyTopic = new sns.Topic(this, 'LowUrgencyTopic');
    this.lowUrgencyTopic.addSubscription(new subs.UrlSubscription(props.lowUrgencyUrl));
  }
}
