import route53 = require('@aws-cdk/aws-route53');
import cdk = require('@aws-cdk/core');

interface ZoneStackProps extends cdk.StackProps {
  zoneAttrs: route53.HostedZoneAttributes;
}

export class ZoneStack extends cdk.Stack {
  public readonly zone: route53.IHostedZone;

  constructor(scope: cdk.Construct, name: string, props: ZoneStackProps) {
    super(scope, name, props);
    this.zone = route53.HostedZone.fromHostedZoneAttributes(this, 'HostedZone', props.zoneAttrs);
  }
}
