# PDMS/EventBus/ConfigService for GDPR compliance

PDMS EventBus Lambda Handler (Golang) for the Extensions Config Service.

### Related Resources

 * Config Service: https://git-aws.internal.justin.tv/extensions/configuration
 * Config Service Infra: https://git-aws.internal.justin.tv/devhub/config-service-infra (lambda defined on a CDK stack)
 * PDMS onboarding: https://wiki.twitch.com/pages/viewpage.action?spaceKey=SEC&title=PDMS+Service+Onboarding
 * EventBus docs: https://git-aws.internal.justin.tv/pages/eventbus/docs/subscribers/lambda_handlers/
 * EventBus Dashboard: https://eventbus.internal.justin.tv/services/69

### How it works

 1. User account was deleted, after a while the account is fully destroyed and the "UserDestroy" event is sent.
 2. EventBus puts a message on our SQS queue, that was configured as a Subscription Target in their dashboard.
 3. Lambda triggers with the SQS queue message. Using the EventBus client to securely read the message content.
 4. Lambda authorizes with Owl and Cartman (see below for details).
 5. Lambda calls ConfigService API to delete all configs on the channel of the user that was destroyed.
 6. ConfigService API removes user information

If there's an error, the lambda will retry a few times and then will send the message to a dead-letter-queue. There's a CloudWatch alert on the dead-letter-queue in case some EventBus event could not be resolved. CloudWatch logs should contain information about what went wrong.

Authorization Details:

 * Lambda is registered in Owl as an App client (using a clientID and secret pair that was generated on the Twitch account "tothemario").
 * Call Owl API `POST /token` endpoint (ExchangeClientCredentials) with the client secret to exchange client credentials and get an OAuth token that identifies the lambda App.
 * Use the OAuth token to call Cartman API `GET /authorization_token` with the capability `extensions::edit_broadcaster_configuration`
 * The Cartman capability is configured to check in a [GDS](https://git-aws.internal.justin.tv/gds/gds) whitelist to see if the calling App client is allowed to get the capability (related PR: https://git-aws.internal.justin.tv/web/cartman/pull/320)
 * GDS whitelist is checked to allow the Lambda App client (related PR: https://git-aws.internal.justin.tv/gds/gds/pull/3540)
 * With the signed Cartman token, Lambda calls the ConfigService API `DELETE /channel/<user_id>` to delete the configurations on the channel of the user that no longer has a Twitch account.
 * ConfigService verifies the Cartman capability (https://git-aws.internal.justin.tv/extensions/configuration/blob/master/services/main/auth/cartman_credentials.go#L40)

### Debug EventBus/PDMS issues

If the dead-letter-queue has messages or the regular sqs queue has old messages that were not processed, there will be an alert to let developer know that some user data could not be processed.

 1. Go to AWS console > Lambda > Monitoring > View Logs in CloudWatch
 2. CloudWatch > Insights > Select log gropup that contains "PDMSLambda" on the name
 3. Pick a time that includes the error
 4. Include `| filter @message like "error"` in the query. When the lambda handler returns an error, error messages will be prefixed with "error dispatching SQS message" or similar.

### Deploy

 * Use `make push-dev` to push the current branch origin/develop, which triggers a Jenkins deploy to dev environment.
 * Make PR and merge in master, which trigger a Jenkins deploy to production.

Follow the deploy in the Jenkins pipeline: https://jenkins.internal.justin.tv/job/devhub/job/config-service-pdms-lambda/

See `Jenkinsfile` and `Dockerfile` for implementation details.
