package clients

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/credentials/stscreds"
	"github.com/aws/aws-sdk-go/service/lambda"

	"code.justin.tv/amzn/PDMSLambdaTwirp"
	twirplambdatransport "code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
)

func MustNewPDMSCli(sess client.ConfigProvider, pdmsAPILambdaARN, pdmsRoleARN string) PDMSLambdaTwirp.PDMSService {
	creds := stscreds.NewCredentials(sess, pdmsRoleARN)                                 // assume role when calling PDMS lambda through the AWS API
	pdmsLambdaCli := lambda.New(sess, &aws.Config{Credentials: creds})                  // AWS lambda client
	pdmsTransportCli := twirplambdatransport.NewClient(pdmsLambdaCli, pdmsAPILambdaARN) // stub for Twirp
	return PDMSLambdaTwirp.NewPDMSServiceProtobufClient("", pdmsTransportCli)
}
