Follow these steps to debug the application in Visual Studio 2019.

1. Ensure no instance of the application is running.
1. In Visual Studio, select "Start Debugging" from the "Debug" menu (or press F5).  This will open a command prompt but will not start the application.
1. Set breakpoints in the main process JavaScript files (e.g. public\electron.js) as desired.  The breakpoint marks will appear disabled.
1. Select "Attach to Process..." from the "Debug" menu (or press Ctrl+Alt+P).  The "Attach to Process" dialog will open.
1. Select "Chrome devtools protocol websocket (no authentication)" in the "Connection type" drop-down list box.  The "Available processes" list view will empty.
1. Wait for the command prompt opened in step 1 to display "Debugger listening on ws://127.0.0.1:6006/`GUID`".
1. Enter "127.0.0.1:6006" in the "Connection target" text box then click the "Refresh" button.  A process will appear in the "Available processes" list view and the "Attach" button will enable.
1. Click the "Attach" button.  The "Attach to 'file://' - Select Code Type" dialog will appear.
1. Click the "JavaScript (Node.js 8+)" check box then click the "OK" button.  All dialogs will disappear and all breakpoint marks will enable.

Upon closing the Electron application, the command prompt opened in step 2 will close.

https://stackoverflow.com/questions/46500302/attach-visual-studio-debugger-to-electron-app

It is also possible to debug a release build.  After performing the operations listed in the `Building the project` section of the
[main read-me file](README.md), run `".\dist\win-unpacked\Twitch Developer Rig.exe" --inspect-brk=6006` and follow the above steps
starting with step 3.

Follow these steps to debug a release build on macOS.

1. Run "./dist/mac/Twitch\ Developer\ Rig.app/Contents/MacOS/Twitch\ Developer\ Rig --inspect-brk=6006".  The application will start but no window will appear.
1. Visit "chrome://inspect/#devices" in Chrome.
1. Click the "inspect" link.  The debugger will load the first file containing a "debugger" statement.
1. For each loaded file, set any desired breakpoints in that file and click the "run" button to continue to the next file.  After all such files load, the application window will appear.
