# Developer Rig

The Developer Rig is an Electron application written in JavaScript with a React front end written in TypeScript.

## Prerequisites

- [yarn](https://yarnpkg.com)
- [Git for Windows](https://gitforwindows.org) (required for Windows only)
- Visual Studio 2019 (optional for Windows to debug the Electron application)

## Set-up

You must be on the WPA2 network or otherwise have access to [Twitch's internal NPM registry](https://pkgs.xarth.tv/artifactory/api/npm/vr-npm).

1.  Sign in to [Artifactory](https://pkgs.xarth.tv) with your LDAP user name and password.
1.  Click your user name in the upper-right-hand corner of the screen.  Your User Profile will open.
1.  Type your password and click `Unlock`.
1.  In the Authentication Settings section, click the COPY icon next to the `Encrypted Password` field.  This will copy your encrypted password onto the clipboard for use in the first command below.
1.  In a terminal window (Git Bash on Windows), execute the following commands.  This will create a local `.npmrc` file and install all of the Developer Rig's dependencies.  Note that the registry is not https://pkgs.xarth.tv.
    1.  `curl -L -u <LDAP user name>:<Encrypted Password> https://packages.internal.justin.tv/artifactory/api/npm/auth > .npmrc`
    1.  `echo 'registry=https://packages.internal.justin.tv/artifactory/api/npm/vr-npm/' >> .npmrc`
    1.  `yarn`

## Building the project

Use a command prompt (Windows) or terminal window (Linux and macOS) to run the following commands.

1.  If you have not already done so, run `git clone gds/extension-coordinator` outside of the `developer-rig` repository's directory.
1.  `cd extension-coordinator` to change the current directory to the `gds/extension-coordinator` repository's directory.
1.  `git checkout v7.51.1` to switch to the commit for version 7.51.1, the version the Developer Rig currently serves.
1.  If you have not already done so, run `yarn` to configure the dependencies.  On macOS, you will receive an error for `node-pre-gyp`.  You may safely ignore this error.
1.  `yarn build:production` to create `lib/extension-coordinator.umd.js`.
1.  Copy that file to the `public` directory in the `developer-rig` repository's directory.
1.  Change the current directory to the `developer-rig` repository's directory.
1.  On Windows, run `build.cmd`.  This will build the Windows installer application.
1.  On macOS, run `./build-mac`.  This will build the Linux and macOS installer applications.

## Running the project

First, perform the operations listed in the `Building the project` section above except for the final `build` commands.  The
installers are not necessary to run the project for development purposes.

Regardless of the method used to run the project, editing any file in the `src` directory (i.e., files that constitute the Electron
"renderer" process) will cause the Developer Rig to reload with those changes.  You must restart the project if you want to change
any of the files in the `public` directory that constitute the Electron "main" process (e.g. `electron.js`).

In order to successfully invoke "View in browser", you must build the front end by executing `yarn react-build` in a command prompt
(Windows) or terminal window (Linux and macOS) before running the project as described below.  Changes to files involved in "View
in browser", such as `external-view/component.tsx`, will not be updated live in the browser.  You must rebuild the front end.

### Windows in Visual Studio 2019

On Windows, if you have an installation of Visual Studio 2019, you may open the `developer-rig.sln` file.

See [DEBUG.md](DEBUG.md) for instructions on how to debug the application.

### All other environments

1.  Open a command prompt (Windows) or terminal window (Linux and macOS).
1.  Change to the project directory.
1.  Execute `yarn start`.

## Testing the project

1.  Open a command prompt (Windows) or terminal window (Linux and macOS).
1.  Change to the project directory.
1.  Execute `yarn test`.

## Updating Extension Coordinator

The Developer Rig build process uses the types given in the `extension-coordinator` package available from Artifactory.  To upgrade
to a newer version of Extension Coordinator, follow these instructions.

1.  Modify the `extension-coordinator` entry in `package.json` to reference the desired version.
1.  Run `yarn` in a command prompt (Windows) or terminal window (Linux and macOS) to get that version from Artifactory.
1.  If the desired version is not a released, tagged version, visit the `gds/extension-coordinator` repository to determine the commit hash associated with the desired version.
1.  Perform the operations listed in the `Building the project` section above, substituting the commit hash or desired, tagged version in step 3.

## Running a production build

1.  Perform the operations listed in the `Building the project` section above.
1.  On Windows, run `".\dist\win-unpacked\Twitch Developer Rig.exe"`.
1.  On macOS, run `./dist/mac/Twitch\ Developer\ Rig.app/Contents/MacOS/Twitch\ Developer\ Rig`.
