const fs = require('fs');
const { join } = require('path');
const packagePath = join(process.cwd(), 'package.json');
const packageContent = fs.readFileSync(packagePath, 'utf8');
const rx = /([0-9])\.([0-9])\.([0-9]+)/;
const matches = rx.exec(packageContent);
const [currentVersion, major, minor, patch] = matches;
const newVersion = `${major}.${minor}.${1 + Number(patch)}`;

modifyFile(packagePath);

function modifyFile(filePath) {
  let content = fs.readFileSync(filePath, 'utf8');
  content = content.replace(currentVersion, newVersion);
  fs.writeFileSync(filePath, content);
}
