const { sendEvent } = require('./analytics');

const events = {
  dx_rig_create_project: {
    code_used: 'twitchdev/extensions-hello-world',
    created_extension_in_rig: false,
  },
  dx_rig_create_funnel_step: {
    step_label: 'complete',
  },
  dx_rig_create_view: {
    view_type: 'panel',
    viewer_type: 'Broadcaster',
    channel_id: '265737932',
    view_metadata: '{"channelId":"265737932","configurationAnchor":"panel","dashboardAnchor":"panel","displayChannelName":"monstercat","extensionType":"panel","features":{"isBitsEnabled":false,"isChatEnabled":false,"isSubscriptionStatusAvailable":false},"frameSize":{"width":1280,"height":720},"identityOption":"Unlinked","isPopout":false,"label":"","linkedUserId":"265737932","mobileHeight":"","mobileSize":"iPhone X/XS (375x822)","mobileWidth":"","orientation":"Portrait","overlayHeight":"","overlaySize":"1280x720","overlayWidth":"","playerHeight":"","playerSize":"1280x720","playerWidth":"","supportedAnchors":["panel","video_overlay","component"],"viewerType":"Broadcaster"}',
  },
  dx_rig_update_project: {
    update_label: 'frontendFolderName',
  },
  dx_rig_on_close: {},
  dx_rig_on_open: {},
  dx_rig_load_project: {
    code_used: 'twitchdev/extensions-hello-world',
  },
  dx_rig_edit_extension_context: {
    view_type: 'panel',
    context_name: 'theme',
    original_value: 'light',
    final_value: 'dark',
  },
  dx_rig_nav_click: {
    tab_name: 'Project Details',
  },
  dx_rig_button_click: {
    button_name: 'Project Actions',
  },
  dx_rig_link_click: {
    link_name: 'Join us on Discord',
    link_url: 'https://discord.gg/ZFC9AZy',
  },
};

Object.keys(events).forEach((name) => {
  sendEvent({ eventName: name, eventData: events[name] });
  console.log(`sent event "${name}"`);
});
