const { ipcMain } = require('electron');
const { isDebuggingProduction } = require('./debug');

if (isDebuggingProduction()) {
  debugger;
}

const functions = {};

ipcMain.on('api', async (event, path, request) => {
  try {
    event.sender.send(`api${path}`, undefined, await functions[path](request));
  } catch (ex) {
    event.sender.send(`api${path}`, ex.message);
  }
});

module.exports = {
  add: (path, fn) => {
    functions[path] = fn;
  },
};
