const { readFile } = require('fs');
const { isDebuggingProduction } = require('./debug');

if (isDebuggingProduction()) {
  debugger;
}

module.exports = {
  readFile: async (filePath) => {
    return await new Promise((resolve, reject) => {
      readFile(filePath, 'utf8', (ex, data) => {
        if (ex) {
          reject(ex);
        }
        else {
          resolve(data);
        }
      });
    });
  },
};
