(function() {
  const container = {};
  let loggingUnknownActions = false;
  const actions = {
    'extension-frame-init': (data) => {
      const ExtensionFrame = window['extension-coordinator'].ExtensionFrame;
      container.parameters = data.parameters;
      container.channelId = data.channelId;
      container.parameters.parentElement = document.getElementById('extension-frame');
      container.parameters.dobbin = { trackEvent: () => { } };
      container.parameters.getDisplayState = () => ({
        anchor: container.parameters.anchor,
        isVisible: true,
        position: data.position,
      });
      container.lastPosition = data.position;
      container.frame = new ExtensionFrame(container.parameters);
    },
    'extension-frame-context': (data) => {
      data = {
        ...data,
        action: 'twitch-ext-context',
      };
      postExtensionMessage(data);
    },
    'extension-frame-visibility': (data) => {
      data = {
        ...data,
        context: null,
        action: 'twitch-ext-visibility-changed',
      };
      postExtensionMessage(data);
    },
    'twitch-ext-rig-log': (data) => {
      postParentMessage(data);
    },
    'supervisor-ready': (_data) => { },
  };

  window.addEventListener('message', (event) => {
    if (event.data && event.data.action) {
      const fn = actions[event.data.action];
      if (fn) {
        fn(event.data);
      } else if (loggingUnknownActions) {
        console.error(`Unexpected extension frame event action "${event.data.action}"`);
      }
    }
  });

  function postExtensionMessage(data) {
    const extensionWindow = document.getElementById('extension-frame').getElementsByTagName('iframe')[0].contentWindow;
    extensionWindow.postMessage(data, '*');
  }

  function postParentMessage(data) {
    window.parent.postMessage(data, '*');
  }
}());
