const electronLog = require('electron-log');
const express = require('express');
const fs = require('fs');
const { isDebuggingProduction } = require('./debug');

if (isDebuggingProduction()) {
  debugger;
}

module.exports = (directory, port, redirections) => {
  if (!fs.existsSync(directory)) {
    throw new Error(`cannot find "${directory}"`);
  }
  const app = express();
  app.use((req, _res, next) => logRequest(req, next));
  app.use((err, req, _res, next) => logRequest(req, next, err));
  app.use(express.static(directory));
  return new Promise((resolve, reject) => {
    const server = app.listen(port, () => {
      const address = server.address();
      electronLog.info(`Serving assets from http://${address.address}:${address.port}`);
      resolve(server);
    });
    // https://stackoverflow.com/a/27040451
    server.on('error', reject);
  });

  function logRequest(req, next, error) {
    const date = `[${new Date().toUTCString()}]`;
    const requestLog = `${req.method} ${req.url}`;
    if (error) {
      electronLog.error(date, 'ERROR:', requestLog);
      electronLog.error(error);
      redirections.onStderr(requestLog);
    } else {
      electronLog.info(date, '-', requestLog);
      redirections.onStdout(requestLog);
    }
    next();
  }
};
