const { resolve } = require('path');
const host = require('./host');

process.on('uncaughtException', (err) => {
  // This is essentially the default implementation of uncaughtException.  I
  // have it here so I can set a breakpoint.
  console.error(err);
  process.exit(1);
});

runTests();

async function runTests() {
  const redirections = {
    onStderr: () => { },
    onStdout: () => { },
  };

  // Test failed hosting.
  try {
    await host('fail', redirections);
    console.error('unexpected success');
  } catch (ex) {
    // Ignore expected exception.
    if (ex.message !== 'cannot find "fail"') {
      console.error(ex);
    }
  }

  // Test successful hosting.
  const server = await host(resolve('..', 'extensions-hello-world', 'public'), redirections);

  // Test re-hosting failure.
  try {
    await host(resolve('..', 'extensions-hello-world', 'public'), redirections);
    console.error('unexpected success');
  } catch (ex) {
    if (ex.message !== 'listen EADDRINUSE :::8080') {
      console.error(ex);
    }
  }

  // Test stopping hosting.
  server.close();
}
