const { Menu, MenuItem, shell } = require('electron');

function createMenu(app, showAbout, createProject, openProject) {
  // Create the specifications for the menu bar and sub-menus.
  const fileMenu = {
    label: 'File',
    submenu: [
      {
        label: 'New Project...',
        click: createProject,
        accelerator: 'CommandOrControl+N',
      },
      {
        label: 'Open Project...',
        click: openProject,
        accelerator: 'CommandOrControl+O',
      },
    ],
  };
  const editMenu = {
    label: 'Edit',
    submenu: [
      { role: 'undo' },
      { role: 'redo' },
      { type: 'separator' },
      { role: 'cut' },
      { role: 'copy' },
      { role: 'paste' },
      { role: 'delete' },
      { role: 'selectAll' },
    ],
  };
  const viewMenu = {
    label: 'View',
    submenu: [
      { role: 'reload' },
      { role: 'forceReload' },
      { role: 'toggleDevTools' },
      { type: 'separator' },
      { role: 'resetZoom' },
      { role: 'zoomIn' },
      { role: 'zoomOut' },
      { type: 'separator' },
      { role: 'togglefullscreen' },
    ],
  };
  const helpMenu = {
    role: 'help',
    submenu: [
      {
        label: 'Learn More',
        click() { shell.openExternal('https://dev.twitch.tv'); },
      },
    ],
  };
  const template = [
    fileMenu,
    editMenu,
    viewMenu,
    helpMenu,
  ];

  // Augment the menus as appropriate for each platform.
  const productName = 'Twitch Developer Rig';
  if (process.platform === 'darwin') {
    template.unshift({
      label: app.getName(), // MacOS sets this.
      submenu: [
        { label: `About ${productName}`, role: 'about' },
        { type: 'separator' },
        { role: 'services', submenu: [] },
        { type: 'separator' },
        { label: `Hide ${productName}`, role: 'hide' },
        { role: 'hideOthers' },
        { role: 'unhide' },
        { type: 'separator' },
        { label: `Quit ${productName}`, role: 'quit' },
      ],
    });
    editMenu.submenu.push(
      { type: 'separator' },
      {
        label: 'Speech',
        submenu: [
          { role: 'startSpeaking' },
          { role: 'stopSpeaking' },
        ],
      },
    );
    const windowMenu = {
      role: 'window',
      submenu: [
        { role: 'close' },
        { role: 'minimize' },
        { role: 'zoom' },
        { type: 'separator' },
        { role: 'front' },
      ],
    };
    template.splice(template.indexOf(helpMenu), 0, windowMenu);
  } else {
    fileMenu.submenu.push(
      { type: 'separator' },
      { role: 'quit' },
    );
    helpMenu.submenu.push(
      {
        label: `About ${productName}`,
        click: showAbout,
      },
    );
  }

  // Create and show the menu bar.
  const menu = Menu.buildFromTemplate(template);
  Menu.setApplicationMenu(menu);
}

function createContextMenu() {
  const contextMenu = new Menu();
  contextMenu.append(new MenuItem({ role: 'toggleDevTools' }));
  return contextMenu;
}

module.exports = { createMenu, createContextMenu };
