window.rig = createRig();

function createRig() {
  const MAX_HISTORY_SIZE = 500;
  const rig = {
    update: () => { },
    history: [],
    log: (log, frameId) => {
      frameId = frameId || 'window';
      rig.history.push({ log, frameId });
      rig.history = rig.history.slice(-MAX_HISTORY_SIZE);
      rig.update(log, frameId);
    },
  };

  window.addEventListener('message', event => {
    if (event.data.action === 'twitch-ext-rig-log') {
      const frames = document.getElementsByClassName('rig-frame');
      const frame = Array.prototype.find.call(frames, (frame) => frame.contentWindow === event.source);
      if (frame) {
        const frameId = frame.title;
        const messages = event.data.messages.map((message) => message instanceof Object ? JSON.stringify(message) : message);
        const message = messages.join(' ');
        rig.log(message, frameId);
      } else {
        console.warn('message received from unknown source');
      }
    }
  });

  return rig;
}
