function createVersion(s) {
  // Remove any initial 'v'.
  if (s.startsWith('v')) {
    s = s.substr(1);
  }

  // Split the string into an array of numbers.
  const parts = !~s.indexOf('.') && isNaN(Number(s)) ? [] : s.split('.').map((e) => parseInt('0' + e, 10));

  // Construct and return the Version object.
  return {
    asNumber: () => parts.reduce((p, c, i) => p + c << (11 * (2 - i))),
    matchesPart,
    selectVersion,
    toString,
  };

  function matchesPart(part, index) {
    return part === parts[index];
  }

  function selectVersion(versions) {
    versions = [...versions].sort(compareVersions).reverse();
    const latestVersion = versions[0];
    parts.forEach((part, index) => {
      versions = versions.filter((version) => version.matchesPart(part, index));
    });
    return versions[0] || latestVersion;
  }

  function toString() {
    return 'v' + parts.join('.');
  }
}

function compareVersions(a, b) {
  [a, b] = [a, b].map((v) => v.asNumber());
  return a - b;
}

module.exports = { createVersion, compareVersions };
