import { setupShallowTest } from '../tests/enzyme-util/shallow';
import { ChannelIdOrNameInput } from './component';
import { DeveloperRigUserId } from '../core/models/rig';
import { ChangeEventFn } from '../tests/utils';

describe('<ChannelIdOrNameInput />', () => {
  const setupShallow = setupShallowTest(ChannelIdOrNameInput, () => ({
    name: 'test',
    placeholder: 'test',
    value: 'test',
    onChange: jest.fn() as (event: React.FormEvent<HTMLInputElement>) => void,
  }));

  it('renders correctly', () => {
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('disables textbox upon checking Developer Rig user', () => {
    const { props, wrapper } = setupShallow();
    wrapper.find('Radio').first().prop<ChangeEventFn>('onChange')({ currentTarget: { name: 'DeveloperRigUserId', checked: true } });
    expect(props.onChange).toHaveBeenCalledWith({ currentTarget: { name: 'test', value: DeveloperRigUserId } });
  });

  it('disables textbox upon checking current user', () => {
    const { props, wrapper } = setupShallow();
    wrapper.find('Radio').last().prop<ChangeEventFn>('onChange')({ currentTarget: { name: 'CurrentUserId', checked: true } });
    expect(props.onChange).toHaveBeenCalledWith({ currentTarget: { name: 'test', value: 'id' } });
  });

  it('switches radio buttons and enables textbox', () => {
    const { props, wrapper } = setupShallow();
    wrapper.find('Radio').last().prop<ChangeEventFn>('onChange')({ currentTarget: { name: 'CustomUserId', checked: true } });
    expect(props.onChange).toHaveBeenCalledWith({ currentTarget: { name: 'test', value: 'test' } });
    wrapper.find('Radio').first().prop<ChangeEventFn>('onChange')({ currentTarget: { name: 'DeveloperRigUserId', checked: true } });
    expect(props.onChange).toHaveBeenCalledWith({ currentTarget: { name: 'test', value: DeveloperRigUserId } });
    wrapper.find('Radio').last().prop<ChangeEventFn>('onChange')({ currentTarget: { name: 'CustomUserId', checked: true } });
    expect(props.onChange).toHaveBeenCalledWith({ currentTarget: { name: 'test', value: 'test' } });
    expect(wrapper.find('Input').first().prop<boolean>('disabled')).toBe(false);
  });

  it('accepts input', () => {
    const { props, wrapper } = setupShallow();
    const event = { currentTarget: { name: 'test', value: 'test' } };
    wrapper.find('Input').prop<ChangeEventFn>('onChange')(event);
    expect(props.onChange).toHaveBeenCalledWith(event);
  });
});
