import * as React from 'react';
import './component.sass';
import { DeveloperRigUserId } from '../core/models/rig';
import { LocalStorage } from '../util/local-storage';
import { Input, InputType, Radio } from 'twitch-core-ui';

export interface Props {
  name: string;
  value: string;
  placeholder?: string;
  onChange: (event: React.FormEvent<HTMLInputElement>) => void;
}

enum Selection {
  CurrentUserId = 'CurrentUserId',
  CustomUserId = 'CustomUserId',
  DeveloperRigUserId = 'DeveloperRigUserId',
}

interface State {
  selection: Selection;
  lastChannelId: string;
  [key: string]: Selection | string;
}

export class ChannelIdOrNameInput extends React.Component<Props, State> {
  private localStorage = new LocalStorage();
  private userId = this.localStorage.rigLogin!.id;
  public state: State = {
    selection: this.props.value === this.userId ? Selection.CurrentUserId : this.props.value === DeveloperRigUserId ? Selection.DeveloperRigUserId : Selection.CustomUserId,
    lastChannelId: '',
  };

  public render() {
    const { name, onChange, placeholder, value } = this.props;
    const { selection } = this.state;
    return (
      <div className="channel-id-or-name-input">
        <Input disabled={selection !== Selection.CustomUserId} name={name} placeholder={placeholder} type={InputType.Text} value={value} onChange={onChange} />
        <div>
          <Radio checked={selection === Selection.DeveloperRigUserId} label="Use Developer Rig user" name={Selection.DeveloperRigUserId} onChange={this.onChange} />
          <Radio checked={selection === Selection.CurrentUserId} label="Use current user" name={Selection.CurrentUserId} onChange={this.onChange} />
          <Radio checked={selection === Selection.CustomUserId} label="Use custom user" name={Selection.CustomUserId} onChange={this.onChange} />
        </div>
      </div>
    );
  }

  private onChange = (event: React.FormEvent<HTMLInputElement>) => {
    const { name, checked } = event.currentTarget;
    const selection = name as Selection;
    if (checked) {
      this.setState({ selection });
      if (this.state.selection === Selection.CustomUserId) {
        this.setState({ lastChannelId: this.props.value });
      }
      const value = selection === Selection.CurrentUserId ? this.userId : selection === Selection.DeveloperRigUserId ? DeveloperRigUserId : this.state.lastChannelId;
      this.props.onChange({ currentTarget: { name: this.props.name, value } } as React.FormEvent<HTMLInputElement>);
    }
  };
}
