import { setupShallowTest } from '../tests/enzyme-util/shallow';
import { CheckCertificateDialog } from './component';
import { ShallowWrapper } from 'enzyme';
import { ChangeEventFn } from '../tests/utils';

describe('<CheckCertificateDialog />', () => {
  const setupShallow = setupShallowTest(CheckCertificateDialog, () => ({
    exceptionRequest: {
      url: 'protocol://hostname/path',
      error: 'error',
      certificate: {},
    },
    closeHandler: jest.fn(),
  }));

  it('renders correctly', () => {
    let { warn } = console;
    console.warn = jest.fn();
    const { wrapper } = setupShallow();
    wrapper.find('Dialog').dive().find('InputProperty').forEach((node: ShallowWrapper) => node.dive());
    wrapper.find('Dialog').dive().find('Property').forEach((node: ShallowWrapper) => node.dive());
    expect(wrapper.debug()).toMatchSnapshot();
    [warn, console.warn] = [console.warn, warn];
    expect(warn).toHaveBeenCalled();
  });

  it('onChange sets allowance state', async () => {
    let { warn } = console;
    console.warn = jest.fn();
    const { wrapper } = setupShallow();
    const name = 'allowance';
    const value = 'Yes';
    wrapper.find('Radio').first().prop<ChangeEventFn>('onChange')({ currentTarget: { name, value } });
    expect(wrapper.state(name)).toBe(value);
    [warn, console.warn] = [console.warn, warn];
    expect(warn).toHaveBeenCalled();
  });

  it('onChange sets isEphemeral state', async () => {
    let { warn } = console;
    console.warn = jest.fn();
    const { wrapper } = setupShallow();
    const name = 'isEphemeral';
    const expectedValue = true;
    wrapper.find('CheckBox').first().prop<ChangeEventFn>('onChange')({ currentTarget: { name, checked: !expectedValue } });
    expect(wrapper.state(name)).toBe(expectedValue);
    [warn, console.warn] = [console.warn, warn];
    expect(warn).toHaveBeenCalled();
  });

  it('onChange sets scope state', async () => {
    let { warn } = console;
    console.warn = jest.fn();
    const { wrapper } = setupShallow();
    const name = 'scope';
    const expectedValue = 'expectedValue';
    wrapper.find(`Radio[name="${name}"]`).first().prop<ChangeEventFn>('onChange')({ currentTarget: { name, value: expectedValue + ': test' } });
    expect(wrapper.state(name)).toBe(expectedValue);
    [warn, console.warn] = [console.warn, warn];
    expect(warn).toHaveBeenCalled();
  });

  it('onChange warns of unexpected name', () => {
    let { error, warn } = console;
    console.error = jest.fn();
    console.warn = jest.fn();
    const { wrapper } = setupShallow();
    const name = 'unexpected';
    const expectedValue = true;
    wrapper.find('CheckBox').first().prop<ChangeEventFn>('onChange')({ currentTarget: { name, checked: !expectedValue } });
    [error, console.error, warn, console.warn] = [console.error, error, console.warn, warn];
    expect(error).toHaveBeenCalled();
    expect(warn).toHaveBeenCalled();
  });

  it('invokes closeHandler when OK button is clicked', () => {
    let { warn } = console;
    console.warn = jest.fn();
    const { props, wrapper } = setupShallow();
    wrapper.find('Dialog').dive().find('Modal').dive().find('ModalFooter').dive().find('Button').first().simulate('click');
    expect(props.closeHandler).toHaveBeenCalled();
    [warn, console.warn] = [console.warn, warn];
    expect(warn).toHaveBeenCalled();
  });
});
