import * as React from 'react';
import { CoreImage, Display, Layout, FlexDirection, CoreText, AlignItems, FontSize, CoreLink, ProgressBar, ProgressBarAnimationDirection } from 'twitch-core-ui';
import wrench from '../../../img/wrench.png';
import { sendEvent } from '../../../util/api';

interface Props {
  estimatedSaveDurationSeconds: number;
  createStatus?: CreateProjectStatus;
}

export enum CreateProjectStatus {
  Loading,
  Error,
  Success,
}

export class CreateProjectWizardStepThree extends React.Component<Props> {
  componentDidMount() {
    sendEvent('dx_rig_create_funnel_step', { step_label: 'complete' });
  }

  render() {
    const { estimatedSaveDurationSeconds, createStatus } = this.props;
    return (
      <Layout
        alignItems={AlignItems.Center}
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        padding={4}
      >
        {createStatus === CreateProjectStatus.Loading && (
          <ProgressBar
            animationDirection={ProgressBarAnimationDirection.Up}
            animationDuration={estimatedSaveDurationSeconds}
            mask
          />
        )}
        {createStatus === CreateProjectStatus.Success && (
          <>
            <CoreImage src={wrench} alt="Done!" />
            <Layout padding={{ top: 2 }}>
              <CoreText fontSize={FontSize.Size5} bold>Your extension project was successfully created!</CoreText>
            </Layout>
          </>
        )}
        {createStatus === CreateProjectStatus.Error && (
          <Layout padding={{ top: 2 }}>
            <CoreText fontSize={FontSize.Size5} bold>An error occurred.  Please check the Developer Tools console.</CoreText>
          </Layout>
        )}
        <Layout padding={{ x: 5, y: 4 }}>
          <CoreText>Welcome to our developer community! Get support from the Twitch Developer community by joining our <CoreLink ariaLabel="CreateProjectWizardStepThree:Discord" linkTo="https://discord.gg/ZFC9AZy" targetBlank>Discord</CoreLink> group. We’re happy to have you on board!</CoreText>
        </Layout>
      </Layout>
    );
  }
}
