import * as React from 'react';
import { Layout, CoreText, Display, StyledLayout, Background, JustifyContent, CoreLink, Interactable, InteractableType, SVG, SVGAsset, AlignItems, TextType } from 'twitch-core-ui';

interface PublicProps {
  description: string;
  linkUrl: string;
  title: string;
  selected: boolean;
  onClick?: (extensionGuideTitle: string) => void;
}

export class ExtensionGuideCard extends React.Component<PublicProps> {
  public render() {
    const { description, linkUrl, selected, title } = this.props;
    return (
      <StyledLayout
        background={Background.Alt}
        border
        className="extension-guide-card"
      >
        <Interactable onClick={this.onInteractableClick} selected={selected} type={InteractableType.Base}>
          <Layout
            alignItems={AlignItems.Center}
            display={Display.Flex}
            justifyContent={JustifyContent.Between}
            padding={{ x: 2, y: 1 }}
          >
            <Layout>
              <CoreText bold type={TextType.H5}>{title}</CoreText>
              <CoreText>{description}</CoreText>
            </Layout>
            <Layout>
              <CoreLink ariaLabel="ExtensionGuideCard:View Instructions" linkTo={linkUrl} targetBlank>
                <Layout display={Display.Flex} alignItems={AlignItems.Center}>
                  View Instructions<SVG asset={SVGAsset.Popout} height={14} />
                </Layout>
              </CoreLink>
            </Layout>
          </Layout>
        </Interactable>
      </StyledLayout>
    );
  }

  private onInteractableClick = () => {
    const { onClick, title } = this.props;
    if (onClick) {
      onClick(title);
    }
  }
}
