export interface ExtensionClient {
  __typename: 'ExtensionClient',
  id: string,
  createdAt: string,
  name: string,
}

export interface ExtensionClientsQueryResponse {
  extensionClients: {
    __typename: 'ExtensionClientConnection',
    edges: Array<{
      __typename: 'ExtensionClientEdge',
      node: ExtensionClient,
    }>,
  } | null,
}

export interface OrganizationFragment {
  __typename: "Organization",
  id: string,
};

export interface CurrentUserOrganizationsQueryResponse {
  currentUser: {
    __typename: "User",
    id: string,
    organizations: Array<{
      __typename: "Organization",
      id: string,
    }> | null,
  } | null,
}

export interface CreateExtensionClientMutationVariables {
  extensionName: string,
}

export interface CreateExtensionClientMutationResponse {
  createExtensionClient: {
    __typename: 'CreateExtensionClientPayload',
    client: ExtensionClient | null,
    error: CreateExtensionClientError | null,
  } | null,
}

export enum CreateExtensionClientError {
  INVALID_NAME = 'INVALID_NAME',
  NAME_IN_USE = 'NAME_IN_USE',
}

export interface ExtensionManifest {
  __typename: 'ExtensionManifest',
  id: string,
  version: string,
}

export interface SaveExtensionManifestMutationResponse {
  saveExtensionManifest: {
    __typename: 'SaveExtensionManifestPayload',
    error: SaveExtensionManifestError | null,
    manifest: ExtensionManifest | null,
  } | null,
};

interface CreateManifestInput {
  extensionID: string;
  authorEmail: string;
  authorName: string;
  name: string;
  version: string;
  hasViewComponent: boolean;
  hasViewVideoOverlay: boolean;
  hasViewPanel: boolean;
  hasViewMobile: boolean;
}

enum ExtensionConfigurationLocation {
  CUSTOM = 'CUSTOM',
  HOSTED = 'HOSTED',
  NONE = 'NONE',
}

export function buildMutationInputForCreateExtensionManifest(
  input: CreateManifestInput
): SaveExtensionManifestInput {
  const Defaults = {
    Paths: {
      panel: "panel.html",
      videoComponent: "video_component.html",
      videoOverlay: "video_overlay.html",
      mobile: "mobile.html",
      config: "config.html"
    }
  };

  const assetManifest: SaveExtensionAssetManifestInput = {
    assetHash: ""
  };

  const whitelists: ExtensionWhitelistsInput = {
    broadcasters: [],
    configURLs: [],
    panelURLs: [],
    testers: []
  };

  const capabilities: SaveExtensionCapabilitiesInput = {
    configurationLocation: ExtensionConfigurationLocation.NONE,
    hasBitsSupport: false,
    hasChatSupport: false,
    requiredConfiguration: "",
    willRequestIdentityLink: false,
    whitelists
  };

  const developerManifest: SaveExtensionDeveloperManifestInput = {
    authorEmail: input.authorEmail,
    testingBaseURI: "https://localhost:8080/"
  };

  const discoveryManifest: SaveExtensionDiscoveryManifestInput = {
    authorName: input.authorName,
    categories: [],
    description: "",
    games: [],
    name: input.name,
    privacyPolicyURL: "",
    summary: "",
    supportEmail: input.authorEmail,
    termsURL: "",
    viewerSummary: ""
  };

  const views: SaveExtensionViewsInput = {
    component: null,
    config: {
      viewerPath: Defaults.Paths.config
    },
    liveConfig: null,
    mobile: null,
    panel: null,
    videoOverlay: null
  };

  if (input.hasViewComponent) {
    const extensionViewInput: SaveComponentViewInput = {
      aspectRatioX: 300,
      aspectRatioY: 200,
      hasAutoscale: true,
      scalePixels: 1024,
      targetHeight: 4000,
      viewerPath: Defaults.Paths.videoComponent,
    };
    views.component = extensionViewInput;
  }

  if (input.hasViewMobile) {
    const extensionViewInput: SaveMobileViewInput = {
      viewerPath: Defaults.Paths.mobile
    };
    views.mobile = extensionViewInput;
  }

  if (input.hasViewPanel) {
    const extensionViewInput: SavePanelViewInput = {
      viewerPath: Defaults.Paths.panel,
      height: 300
    };
    views.panel = extensionViewInput;
  }

  if (input.hasViewVideoOverlay) {
    const extensionViewInput: SaveVideoOverlayViewInput = {
      viewerPath: Defaults.Paths.videoOverlay
    };
    views.videoOverlay = extensionViewInput;
  }

  return {
    input: {
      id: input.extensionID,
      version: input.version,
      assetManifest,
      capabilities,
      developerManifest,
      discoveryManifest,
      views
    }
  };
}

interface SaveExtensionAssetManifestInput {
  assetHash: string,
};

enum ExtensionBitsSupportLevel {
  NONE = "NONE",
  OPTIONAL = "OPTIONAL",
  REQUIRED = "REQUIRED",
}

enum ExtensionSubscriptionsSupportLevel {
  NONE = 'NONE',
  OPTIONAL = 'OPTIONAL',
}

interface SaveExtensionCapabilitiesInput {
  bitsSupportLevel?: ExtensionBitsSupportLevel | null,
  configurationLocation: ExtensionConfigurationLocation,
  hasBitsSupport: boolean,
  hasChatSupport: boolean,
  requiredConfiguration: string,
  subscriptionsSupportLevel?: ExtensionSubscriptionsSupportLevel | null,
  whitelists: ExtensionWhitelistsInput,
  willRequestIdentityLink: boolean,
};

interface ExtensionWhitelistsInput {
  broadcasters: Array<string>,
  configURLs: Array<string>,
  panelURLs: Array<string>,
  testers: Array<string>,
};

interface SaveComponentViewInput {
  aspectRatioX: number,
  aspectRatioY: number,
  hasAutoscale?: boolean | null,
  scalePixels?: number | null,
  targetHeight: number,
  viewerPath: string,
};

interface SaveConfigViewInput {
  viewerPath: string,
};

interface SaveLiveConfigViewInput {
  viewerPath: string,
};

interface SaveMobileViewInput {
  viewerPath: string,
};

interface SavePanelViewInput {
  height: number,
  viewerPath: string,
};

interface SaveVideoOverlayViewInput {
  viewerPath: string,
};

enum SaveExtensionManifestError {
  ANCHOR_REQUIRED = "ANCHOR_REQUIRED",
  INVALID_AUTHOR_EMAIL = "INVALID_AUTHOR_EMAIL",
  INVALID_AUTHOR_NAME_LENGTH = "INVALID_AUTHOR_NAME_LENGTH",
  INVALID_BITS_SUPPORT_LEVEL = "INVALID_BITS_SUPPORT_LEVEL",
  INVALID_COMPONENT_ASPECT_HEIGHT = "INVALID_COMPONENT_ASPECT_HEIGHT",
  INVALID_COMPONENT_ASPECT_RATIO_X = "INVALID_COMPONENT_ASPECT_RATIO_X",
  INVALID_COMPONENT_ASPECT_RATIO_Y = "INVALID_COMPONENT_ASPECT_RATIO_Y",
  INVALID_COMPONENT_ASPECT_WIDTH = "INVALID_COMPONENT_ASPECT_WIDTH",
  INVALID_COMPONENT_TARGET_HEIGHT = "INVALID_COMPONENT_TARGET_HEIGHT",
  INVALID_COMPONENT_VIEWER_PATH = "INVALID_COMPONENT_VIEWER_PATH",
  INVALID_CONFIG_VIEWER_PATH = "INVALID_CONFIG_VIEWER_PATH",
  INVALID_DESCRIPTION_LENGTH = "INVALID_DESCRIPTION_LENGTH",
  INVALID_LIVE_CONFIG_VIEWER_PATH = "INVALID_LIVE_CONFIG_VIEWER_PATH",
  INVALID_MOBILE_VIEWER_PATH = "INVALID_MOBILE_VIEWER_PATH",
  INVALID_NAME_LENGTH = "INVALID_NAME_LENGTH",
  INVALID_PANEL_HEIGHT = "INVALID_PANEL_HEIGHT",
  INVALID_PANEL_VIEWER_PATH = "INVALID_PANEL_VIEWER_PATH",
  INVALID_PRIVACY_URI = "INVALID_PRIVACY_URI",
  INVALID_SCALING_PIXELS = "INVALID_SCALING_PIXELS",
  INVALID_SUMMARY_LENGTH = "INVALID_SUMMARY_LENGTH",
  INVALID_SUPPORT_EMAIL = "INVALID_SUPPORT_EMAIL",
  INVALID_TERMS_URI = "INVALID_TERMS_URI",
  INVALID_TESTING_BASE_URI = "INVALID_TESTING_BASE_URI",
  INVALID_VERSION = "INVALID_VERSION",
  INVALID_VIDEO_OVERLAY_VIEWER_PATH = "INVALID_VIDEO_OVERLAY_VIEWER_PATH",
  INVALID_ZOOM = "INVALID_ZOOM",
  MAX_BROADCASTERS = "MAX_BROADCASTERS",
  MAX_TESTERS = "MAX_TESTERS",
  MAX_WHITELISTED_CONFIG_URLS = "MAX_WHITELISTED_CONFIG_URLS",
  MAX_WHITELISTED_PANEL_URLS = "MAX_WHITELISTED_PANEL_URLS",
  UNAUTHORIZED = "UNAUTHORIZED",
}

interface SaveExtensionDeveloperManifestInput {
  authorEmail: string,
  testingBaseURI: string,
};

interface SaveExtensionDiscoveryManifestInput {
  authorName: string,
  categories: Array<string>,
  description: string,
  games: Array<string>,
  name: string,
  privacyPolicyURL: string,
  summary: string,
  supportEmail: string,
  termsURL: string,
  viewerSummary: string,
};

interface SaveExtensionViewsInput {
  component?: SaveComponentViewInput | null,
  config?: SaveConfigViewInput | null,
  liveConfig?: SaveLiveConfigViewInput | null,
  mobile?: SaveMobileViewInput | null,
  panel?: SavePanelViewInput | null,
  videoOverlay?: SaveVideoOverlayViewInput | null,
};

interface SaveExtensionManifestInput {
  input: {
    assetManifest: SaveExtensionAssetManifestInput,
    capabilities: SaveExtensionCapabilitiesInput,
    developerManifest: SaveExtensionDeveloperManifestInput,
    discoveryManifest: SaveExtensionDiscoveryManifestInput,
    id: string,
    version: string,
    views: SaveExtensionViewsInput,
  }
};
