import { validateProjectName, InputError } from './validate-project-name';
import { CreateExtensionClientError } from '../queries/models';

describe('validateProjectName', () => {
  it('should return an error for empty name', () => {
    expect(validateProjectName('')).toBe(InputError.EMPTY);
  });

  it('should return an error for a name greater than 40 characters', () => {
    const testName = Array.apply(null, Array(41)).map((_) => 'a').join('');
    expect(validateProjectName(testName)).toBe(CreateExtensionClientError.INVALID_NAME);
  });

  it('should return an error for a name with Glitch, Twitch, Extension', () => {
    const testName = 'Twitch Testing Glitch';
    expect(validateProjectName(testName)).toBe(CreateExtensionClientError.INVALID_NAME);
  });

  it('should not return an error for a valid name', () => {
    expect(validateProjectName('My Project')).toBeUndefined();
  });
});
