import { validateVersion, VersionError } from './validate-version';

describe('validateVersion', () => {
  it('should validate versions', () => {
    expect(validateVersion('1.0.0')).toBeUndefined();
    expect(validateVersion('1.0')).toBeUndefined();
    expect(validateVersion('1')).toBeUndefined();
    expect(validateVersion('')).toBe(VersionError.Empty);
    expect(validateVersion('1.0.')).toBe(VersionError.Format);
    expect(validateVersion('a')).toBe(VersionError.Format);
    expect(validateVersion('01234567890123456789012345678901234567890')).toBe(VersionError.Length);
  });
});
