import { setupShallowTest } from '../tests/enzyme-util/shallow';
import { Dialog } from './component';

describe('<Dialog />', () => {
  const setupShallow = setupShallowTest(Dialog, () => ({
    className: 'className',
    canConfirm: true,
    confirmText: 'confirmText',
    title: 'title',
    closeHandler: jest.fn(),
    confirmHandler: jest.fn(),
  }));

  it('renders correctly', () => {
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('does not close if no close handler provided', () => {
    const { props, wrapper } = setupShallowTest(Dialog, () => ({
      className: 'className',
      canConfirm: true,
      confirmText: 'confirmText',
      title: 'title',
      confirmHandler: jest.fn(),
    }))();
    expect(wrapper.find('Modal').dive().find('ModalHeader').dive().find('CoreDismissible')).toHaveLength(0);
    wrapper.find('div').simulate('keydown', { key: 'Escape' });
    expect(props.closeHandler).not.toBeDefined();
  });

  it('closes correctly', () => {
    const { props, wrapper } = setupShallow();
    wrapper.find('Modal').dive().find('ModalHeader').dive().find('CoreDismissible').simulate('click');
    expect(props.closeHandler).toHaveBeenCalled();
    wrapper.find('Modal').dive().find('ModalFooter').dive().find('Button').first().simulate('click');
    expect(props.closeHandler).toHaveBeenCalledTimes(2);
  });

  it('confirms correctly', () => {
    const { props, wrapper } = setupShallow();
    wrapper.find('Modal').dive().find('ModalFooter').dive().find('Button').last().simulate('click');
    expect(props.confirmHandler).toHaveBeenCalled();
  });

  it('handles Enter key-down event', () => {
    const { props, wrapper } = setupShallow();
    const dialog = wrapper.instance() as any;
    dialog.handleKeyDown({ key: 'Enter' });
    expect(props.confirmHandler).toHaveBeenCalled();
  });

  it('handles Escape key-down event', () => {
    const { props, wrapper } = setupShallow();
    const dialog = wrapper.instance() as any;
    dialog.handleKeyDown({ key: 'Escape' });
    expect(props.closeHandler).toHaveBeenCalled();
  });
});
