import * as React from 'react';
import { setupShallowTest } from '../tests/enzyme-util/shallow';
import { DropdownMenu } from './component';
import { timeout } from '../tests/utils';

describe('<DropdownMenu />', () => {
  const defaultGenerator = () => ({
    action: <div />,
    menu: <div />,
    menuClassName: 'menuClassName',
  });
  const setupRenderer = setupShallowTest(DropdownMenu, defaultGenerator);

  it('renders correctly', () => {
    const { wrapper } = setupRenderer();
    expect(wrapper.debug()).toMatchSnapshot();
    wrapper.unmount();
  });

  it('renders correctly when clicked', () => {
    const { wrapper } = setupRenderer();
    wrapper.find('.dropdown-menu__action').simulate('click');
    expect(wrapper.find('.dropdown-menu__menu--open')).toHaveLength(1);
  });

  it('dismiss closes the drop-down', async () => {
    const { wrapper } = setupRenderer();
    wrapper.find('.dropdown-menu__action').simulate('click');
    expect(wrapper.find('.dropdown-menu__menu--open')).toHaveLength(1);
    const instance = wrapper.instance() as any;
    instance.dismiss();
    await timeout();
    expect(wrapper.state('isOpen')).toBe(false);
  });
});
