import * as React from 'react';
import classNames from 'classnames';
import whitetriangle from '../img/whitetriangle.svg';
import './component.sass';

interface Props {
  action: JSX.Element;
  menu: JSX.Element;
  menuClassName: string;
}

interface State {
  isOpen: boolean;
}

export class DropdownMenu extends React.Component<Props, State> {
  public state: State = {
    isOpen: false,
  }

  componentDidMount() {
    document.body.addEventListener('click', this.dismiss);
  }

  componentWillUnmount() {
    document.body.removeEventListener('click', this.dismiss);
  }

  public render() {
    const menuClass = classNames('dropdown-menu__menu', this.props.menuClassName, {
      'dropdown-menu__menu--open': this.state.isOpen,
    });
    const triangleClass = classNames('dropdown-menu__triangle', {
      'dropdown-menu__triangle--open': this.state.isOpen,
    });

    return (
      <div className="dropdown-menu">
        <div onClick={this.toggleDropdown} className="dropdown-menu__action">
          {this.props.action}
          <img alt="+" src={whitetriangle} className={triangleClass} />
        </div>
        <div className={menuClass}>
          {this.props.menu}
        </div>
      </div>
    );
  }

  private dismiss = () => {
    if (this.state.isOpen) {
      setTimeout(() => this.setState({ isOpen: false }));
    }
  }

  private toggleDropdown = () => {
    this.setState((previousState) => ({ isOpen: !previousState.isOpen }));
  }
}
