import { setupShallowTest } from '../../tests/enzyme-util/shallow';
import { Console } from './component';
import { timeout } from '../../tests/utils';

const propGenerator = () => ({
  isWide: false,
  onMinimize: jest.fn(),
});
const setupShallow = setupShallowTest(Console, propGenerator);

describe('<Console />', () => {
  it('renders', async () => {
    const { wrapper } = setupShallow();
    const instance = wrapper.instance() as any;
    const scrollHeight = 1;
    instance.console.current = { scrollHeight };
    await timeout();
    expect(wrapper.debug()).toMatchSnapshot();
    expect(instance.console.current.scrollTop).toBe(scrollHeight);
  });

  it('updates the console upon invoking window.rig.update', async () => {
    const { wrapper } = setupShallow();
    await timeout();
    expect(wrapper.find('.console').children().length).toBe(2);
    expect(wrapper.last().render().text()).toContain('Invoke window.Twitch.ext.rig.log');
    window.rig.history = [
      {
        log: 'test',
        frameId: 'test-frame',
      },
    ];
    window.rig.update();
    expect(wrapper.find('.console').children().length).toBe(2);
    expect(wrapper.last().render().text()).not.toContain('Invoke window.Twitch.ext.rig.log');
  });

  it('renders log messages', async () => {
    const { wrapper } = setupShallow();
    await timeout();
    const expected = { log: 'test', frameId: 'test-frame' };
    wrapper.setState({ logHistory: [expected] });
    expect(wrapper.last().render().text()).toBe(`${expected.frameId} $ ${expected.log}`);
  });

  it('minimizes', async () => {
    const { wrapper } = setupShallow();
    await timeout();
    wrapper.find('svg').simulate('click');
    expect(wrapper.state('isMinimized')).toBe(true);
  });
});
