import { setupShallowTest } from '../../tests/enzyme-util/shallow';
import { EditViewDialog } from './component';
import { ViewerType } from '../../core/models/rig';
import { createViewsForTest } from '../../tests/constants/extension';
import { MobileOrientation } from '../../constants/mobile';
import { ExtensionAnchor, ExtensionPlatform } from 'extension-coordinator';
import { ChangeEventFn } from '../../tests/utils';

describe('<EditViewDialog />', () => {
  const views = createViewsForTest(2, ExtensionAnchor.Component, ViewerType.LoggedOut, { x: 10, y: 10 });
  views[1].type = ExtensionPlatform.Mobile;
  const setupShallow = setupShallowTest(EditViewDialog, () => ({
    viewForEdit: views[0],
    closeHandler: jest.fn(),
    updateViewHandler: jest.fn(),
  }));

  it('correctly closes', () => {
    const { props, wrapper } = setupShallow();
    wrapper.find('Dialog').dive().find('Modal').dive().find('ModalHeader').dive().find('CoreDismissible').simulate('click');
    expect(props.closeHandler).toHaveBeenCalled();
    wrapper.find('Dialog').dive().find('Modal').dive().find('ModalFooter').dive().find('Button').first().simulate('click');
    expect(props.closeHandler).toHaveBeenCalledTimes(2);
  });

  it('saves correctly', () => {
    const { props, wrapper } = setupShallow();
    wrapper.find('Dialog').dive().find('Modal').dive().find('ModalFooter').dive().find('Button').last().simulate('click');
    expect(props.updateViewHandler).toHaveBeenCalled();
  });

  it('changes mobile orientation correctly', () => {
    const extras = { orientation: MobileOrientation.Default };
    const { wrapper } = setupShallow({
      viewForEdit: createViewsForTest(1, ExtensionPlatform.Mobile, ViewerType.LoggedOut, extras)[0],
    });

    let inputs = wrapper.find('Radio');
    expect(inputs.get(0).props.checked).toBeTruthy();
    expect(inputs.get(1).props.checked).toBeFalsy();
    inputs.last().prop<ChangeEventFn>('onChange')({ 'currentTarget': { 'name': 'orientation', 'value': MobileOrientation.Landscape } });
    inputs = wrapper.find('Radio');
    expect(inputs.get(0).props.checked).toBeFalsy();
    expect(inputs.get(1).props.checked).toBeTruthy();
  });
});
