import * as React from 'react';
import './component.sass';
import { FormGroup, Radio } from 'twitch-core-ui';
import { MobileOrientation } from '../../constants/mobile';
import { RigExtensionView } from '../../core/models/rig';
import { ExtensionPlatform } from 'extension-coordinator';
import { Dialog } from '../../dialog';

interface Props {
  viewForEdit: RigExtensionView;
  closeHandler: () => void;
  updateViewHandler: (orientation: MobileOrientation) => void;
}

interface State {
  orientation: MobileOrientation;
}

export class EditViewDialog extends React.Component<Props, State> {
  public state: State = {
    orientation: this.props.viewForEdit.orientation || MobileOrientation.Default,
  }

  private onChange = (input: React.FormEvent<HTMLInputElement>) => {
    const { value } = input.currentTarget;
    this.setState({ orientation: value as MobileOrientation });
  }

  private save = () => {
    const { orientation } = this.state;
    this.props.updateViewHandler(orientation);
  }

  public render() {
    return <>
      <Dialog canConfirm={true} className="edit-view-dialog" confirmText="Save" title={'Edit Orientation'}
        closeHandler={this.props.closeHandler} confirmHandler={this.save}>
        {this.props.viewForEdit.type === ExtensionPlatform.Mobile &&
          <FormGroup label="Orientation">
            <Radio name="orientation" label={MobileOrientation.Portrait} value={MobileOrientation.Portrait} onChange={this.onChange} checked={MobileOrientation.Portrait === this.state.orientation} />
            <Radio name="orientation" label={MobileOrientation.Landscape} value={MobileOrientation.Landscape} onChange={this.onChange} checked={MobileOrientation.Landscape === this.state.orientation} />
          </FormGroup>}
      </Dialog>
    </>;
  }
}
