import { setupShallowTest } from '../../../tests/enzyme-util/shallow';
import { DivOption } from './component';
import { ExtensionAnchor } from 'extension-coordinator';

describe('<DivOption />', () => {
  const setupShallow = setupShallowTest(DivOption, () => ({
    value: ExtensionAnchor.Panel,
    onChange: jest.fn(),
    checked: false,
  }));

  it('renders correctly', () => {
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('correctly renders selected styles when checked', () => {
    const { wrapper } = setupShallow({
      checked: true,
    });
    expect(wrapper.find('.div-option__box--selected').length).toBe(1);
  })
});
