import * as React from 'react';
import './component.sass';
import classNames from 'classnames';
import { ExtensionAnchor, ExtensionMode, ExtensionPlatform } from 'extension-coordinator';
import componentOn from '../../../img/component-on.svg';
import componentOff from '../../../img/component-off.svg';
import overlayOn from '../../../img/overlay-on.svg';
import overlayOff from '../../../img/overlay-off.svg';
import panelOn from '../../../img/panel-on.svg';
import panelOff from '../../../img/panel-off.svg';
import configOn from '../../../img/configuration-on.svg';
import configOff from '../../../img/configuration-off.svg';
import dashboardOn from '../../../img/dashboard-on.svg';
import dashboardOff from '../../../img/dashboard-off.svg';
import mobileOn from '../../../img/mobile-on.svg';
import mobileOff from '../../../img/mobile-off.svg';

interface DivOptionProps {
  value: string;
  onChange: (event: React.FormEvent<HTMLInputElement>) => void;
  checked: boolean;
}

export const ExtensionTypeNames: { [key: string]: string } = {
  [ExtensionAnchor.Component]: 'Component',
  [ExtensionAnchor.Overlay]: 'Overlay',
  [ExtensionAnchor.Panel]: 'Panel',
  [ExtensionMode.Config]: 'Configuration',
  [ExtensionMode.Dashboard]: 'Dashboard',
  [ExtensionPlatform.Mobile]: 'Mobile',
};

const viewTypeImages: { [key: string]: { on: string; off: string; } } = {
  [ExtensionAnchor.Component]: { on: componentOn, off: componentOff },
  [ExtensionAnchor.Overlay]: { on: overlayOn, off: overlayOff },
  [ExtensionAnchor.Panel]: { on: panelOn, off: panelOff },
  [ExtensionMode.Config]: { on: configOn, off: configOff },
  [ExtensionMode.Dashboard]: { on: dashboardOn, off: dashboardOff },
  [ExtensionPlatform.Mobile]: { on: mobileOn, off: mobileOff },
};

export class DivOption extends React.Component<DivOptionProps> {
  private getImage(key: string): string {
    return this.props.checked ? viewTypeImages[key].on : viewTypeImages[key].off;
  }

  public render() {
    const { checked, value, onChange } = this.props;
    const img = this.getImage(value);
    const typeName = ExtensionTypeNames[value];
    const boxClassName = classNames('div-option__box', {
      'div-option__box--selected': checked,
    });
    return (
        <label className="div-option">
          <input type="radio" className="div-option__input" name="extensionType" value={value} onChange={onChange} defaultChecked={checked} />
          <span className={boxClassName}>
            <img className='div-option__image' alt={value} src={img} />
          </span>
        <span className="div-option__text">{typeName}</span>
        </label>
    );
  }
}
