import { setupShallowTest } from '../../tests/enzyme-util/shallow';
import { ComponentView, Props } from '.';
import { CloseButton } from './components/close-button';
import { createExtensionObjectForTest } from '../../tests/constants/extension';
import { ExtensionObject, ExtensionAnchor, ExtensionMode, ExtensionPlatform } from 'extension-coordinator';

const setupShallow = setupShallowTest<Props>(ComponentView, () => ({
  anchor: ExtensionAnchor.Component,
  channelId: 'channelId',
  displayChannelName: 'displayChannelName',
  extension: createExtensionObjectForTest(),
  frameSize: { width: 800, height: 600 },
  frameId: '1',
  installationAbilities: {
    isBitsEnabled: false,
    isChatEnabled: true,
    isSubscriptionStatusAvailable: false,
  },
  isNonoVisible: true,
  isPopout: false,
  mode: ExtensionMode.Viewer,
  platform: ExtensionPlatform.Web,
  bindIframeToParent: jest.fn(),
}));

describe('<ComponentView />', () => {
  it('renders correctly', () => {
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('renders correctly when zoom is true', () => {
    const { wrapper } = setupShallow({
      extension: createExtensionObject(),
    });
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('renders correctly when hideComponent is true', () => {
    const { wrapper } = setupShallow();
    wrapper.find('.component-sidebar-card-main').simulate('click');

    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('hides when the the close button is clicked', () => {
    const { wrapper } = setupShallow();
    wrapper.find(CloseButton).prop('onClick')();

    expect(wrapper.debug()).toMatchSnapshot();
  });

  function createExtensionObject(): ExtensionObject {
    return {
      ...createExtensionObjectForTest(),
      views: {
        component: {
          canLinkExternalContent: false,
          viewerUrl: 'test',
          aspectRatioX: 3,
          aspectRatioY: 2,
          targetHeight: 8000,
          autoScale: true,
          scalePixels: 1000,
          aspectHeight: 0,
          aspectWidth: 0,
          zoom: false,
          zoomPixels: 0,
        },
        config: {
          canLinkExternalContent: false,
          viewerUrl: 'test',
        },
        liveConfig: {
          canLinkExternalContent: false,
          viewerUrl: 'test',
        },
        panel: {
          canLinkExternalContent: false,
          viewerUrl: 'test',
          height: 300,
        },
      },
    };
  }
});
