import * as React from "react"

export interface Props {
  onClick: (event: React.MouseEvent<HTMLDivElement, MouseEvent>) => void;
}

export class SettingsButton extends React.Component<Props> {
  render() {
    return (
      <div className="component-header-icon" onClick={this.props.onClick}>
        <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path fillRule="evenodd" clipRule="evenodd" d="M5.9805 8.26317C4.73984 8.26317 3.73384 7.25717 3.73384 6.0165C3.73384 4.77584 4.73984 3.76984 5.9805 3.76984C7.22117 3.76984 8.22717 4.77584 8.22717 6.0165C8.22717 7.25717 7.22117 8.26317 5.9805 8.26317ZM10.8472 4.9865C10.6465 4.9565 10.4358 4.92784 10.2298 4.90117C10.2052 4.89784 10.1825 4.88117 10.1758 4.8585C10.0805 4.51384 9.94184 4.18184 9.76584 3.87117C9.75384 3.8505 9.75517 3.8245 9.7705 3.8045C9.89717 3.63984 10.0218 3.47384 10.1425 3.31117C10.3052 3.0905 10.2812 2.77784 10.0872 2.58384L9.41317 1.90984C9.2185 1.71584 8.9065 1.69184 8.6865 1.85517C8.52317 1.97517 8.35717 2.1005 8.1925 2.22717C8.1725 2.2425 8.1465 2.2445 8.12584 2.23317C7.81517 2.05584 7.48317 1.9185 7.1385 1.82384C7.11584 1.81784 7.09917 1.79717 7.09584 1.7725C7.06917 1.5665 7.03984 1.35184 7.00984 1.15184C6.96917 0.880504 6.73184 0.666504 6.45717 0.666504H5.50384C5.22917 0.666504 4.99184 0.880504 4.95117 1.15184C4.92117 1.35184 4.89184 1.56184 4.86517 1.76784C4.86184 1.7925 4.84517 1.81517 4.8225 1.82117C4.4785 1.9165 4.14584 2.05517 3.83517 2.23184C3.8145 2.24317 3.7885 2.24184 3.7685 2.2265C3.60384 2.09984 3.43784 1.97517 3.27517 1.8545C3.0545 1.69184 2.7425 1.71517 2.54784 1.90984L1.87384 2.58384C1.67984 2.77784 1.65584 3.0905 1.81917 3.31117C1.93984 3.47384 2.06517 3.63984 2.19117 3.8045C2.2065 3.8245 2.2085 3.8505 2.19717 3.87117C2.0205 4.18184 1.88317 4.51384 1.78784 4.8585C1.78184 4.88117 1.76117 4.89784 1.7365 4.90117C1.53117 4.92784 1.33384 4.9565 1.13317 4.9865C0.862504 5.02717 0.666504 5.26517 0.666504 5.53984V6.49317C0.666504 6.76784 0.862504 7.00517 1.13317 7.04584C1.33384 7.07584 1.53584 7.10517 1.74117 7.13184C1.76584 7.13517 1.78384 7.15184 1.78984 7.1745C1.8845 7.5185 2.02184 7.8505 2.19784 8.16184C2.20984 8.1825 2.20717 8.2085 2.19184 8.2285C2.06517 8.3925 1.93984 8.5585 1.81917 8.72184C1.6565 8.9425 1.67984 9.2545 1.87384 9.4485L2.54784 10.1232C2.7425 10.3172 3.0545 10.3405 3.27517 10.1778C3.4385 10.0572 3.60384 9.9325 3.7685 9.80517C3.7885 9.7905 3.8145 9.78784 3.83517 9.8005C4.14584 9.9765 4.47784 10.1138 4.8225 10.2092C4.84517 10.2152 4.86184 10.2352 4.86517 10.2605C4.89184 10.4665 4.92117 10.6652 4.95117 10.8652C4.99184 11.1365 5.22917 11.3332 5.50384 11.3332H6.45717C6.73184 11.3332 6.96917 11.1365 7.00984 10.8645C7.03984 10.6652 7.06917 10.4625 7.09584 10.2565C7.09917 10.2318 7.11584 10.2138 7.1385 10.2072C7.48317 10.1118 7.81517 9.97517 8.12584 9.79917C8.1465 9.78717 8.1725 9.78984 8.1925 9.80517C8.35717 9.93184 8.52317 10.0572 8.6865 10.1778C8.9065 10.3405 9.2185 10.3172 9.4125 10.1225L10.0872 9.4485C10.2812 9.2545 10.3045 8.9425 10.1418 8.72117C10.0218 8.5585 9.89584 8.3925 9.76984 8.2285C9.7545 8.2085 9.75184 8.1825 9.7645 8.16184C9.9405 7.8505 10.0778 7.5185 10.1732 7.1745C10.1792 7.15184 10.1992 7.13517 10.2245 7.13184C10.4298 7.10517 10.6465 7.07584 10.8472 7.04584C11.1178 7.00517 11.3332 6.76784 11.3332 6.49317V5.53984C11.3332 5.26517 11.1178 5.02717 10.8472 4.9865" fill="#DAD8DE"/>
        </svg>
      </div>
    );
  }
}
