import { setupShallowTest } from '../tests/enzyme-util/shallow';
import { ExtensionViewSelector } from './component';
import { ExtensionAnchor, ExtensionMode, ExtensionPlatform } from 'extension-coordinator';
import { createViewsForTest, createExtensionObjectForTest } from '../tests/constants/extension';
import { ViewerType, ExtensionType } from '../core/models/rig';

describe('<ExtensionViewSelector />', () => {
  let extensionType: ExtensionType;
  const setupShallow = setupShallowTest(ExtensionViewSelector, () => ({
    extension: createExtensionObjectForTest(),
    hasBorder: true,
    isExtensionVisible: true,
    isNonoVisible: true,
    view: createViewsForTest(1, extensionType, ViewerType.LoggedOut)[0],
  }));

  it('renders as config', async () => {
    extensionType = ExtensionMode.Config;
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('renders as component', async () => {
    extensionType = ExtensionAnchor.Component;
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
    expect(wrapper.find('ComponentView')).toHaveLength(1);
    expect(wrapper.find('ComponentView').dive().debug()).toMatchSnapshot();
  });

  it('renders as dashboard', async () => {
    extensionType = ExtensionMode.Dashboard;
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('renders as mobile', async () => {
    extensionType = ExtensionPlatform.Mobile;
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
    expect(wrapper.find('MobileView')).toHaveLength(1);
    expect(wrapper.find('MobileView').dive().debug()).toMatchSnapshot();
  });

  it('renders as overlay', async () => {
    extensionType = ExtensionAnchor.Overlay;
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('renders as panel', async () => {
    extensionType = ExtensionAnchor.Panel;
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('binds iframe to parent', () => {
    const { wrapper } = setupShallow();
    const attribute = { value: undefined };
    const iframe = {
      attributes: { setNamedItem: jest.fn() },
      contentDocument: { createAttribute: jest.fn((_name) => attribute) },
    };
    const instance = wrapper.instance() as any;
    const src = 'src';
    document.getElementById = jest.fn((_name) => ({ src } as unknown as HTMLElement));
    instance.bindIframeToParent(iframe);
    expect(document.getElementById).toHaveBeenCalledWith('coordinatorScriptElement');
    expect(iframe.contentDocument.createAttribute).toHaveBeenCalledWith('coordinatorUrl');
    expect(iframe.attributes.setNamedItem).toHaveBeenCalledWith(attribute);
    expect(attribute.value).toBe(src);
  });
});
