import { setupShallowTest } from '../../tests/enzyme-util/shallow';
import { MobileView } from '.';
import { createExtensionObjectForTest } from '../../tests/constants/extension';
import { MobileOrientation } from '../../constants/mobile';
import { ExtensionPlatform, ExtensionAnchor, ExtensionMode } from 'extension-coordinator';

const setupShallow = setupShallowTest(MobileView, () => ({
  anchor: ExtensionPlatform.Mobile as unknown as ExtensionAnchor,
  channelId: 'channelId',
  extension: createExtensionObjectForTest(),
  frameSize: { width: 100, height: 100 },
  frameId: '1',
  installationAbilities: {
    isBitsEnabled: false,
    isChatEnabled: true,
    isSubscriptionStatusAvailable: false,
  },
  isPopout: false,
  mode: ExtensionMode.Viewer,
  platform: ExtensionPlatform.Mobile,
  orientation: MobileOrientation.Portrait,
  bindIframeToParent: jest.fn(),
}));

describe('<MobileView />', () => {
  it('renders correctly', () => {
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('computes correct styles in portrait orientation', () => {
    const { wrapper } = setupShallow();
    const instance = wrapper.instance() as MobileView;
    const expectedFrameStyles = {
      'bottom': '0',
      'height': '65px',
      'position': 'absolute',
      'width': '100px'
    };
    const expectedViewStyles = {
      'background': '#322F37',
      'height': '100px',
      'width': '100px',
    };

    expect(instance.computeFrameStyles()).toEqual(expectedFrameStyles);
    expect(instance.computeViewStyles()).toEqual(expectedViewStyles);
  });

  it('computes correct styles in landscape orientation', () => {
    const { wrapper } = setupShallow({
      orientation: MobileOrientation.Landscape
    });
    const instance = wrapper.instance() as MobileView;

    const expectedFrameStyles = {
      'height': '100px',
      'position': 'absolute',
      'right': '0',
      'width': '28px'
    };

    const expectedViewStyles = {
      'background': '#322F37',
      'height': '100px',
      'width': '100px',
    };

    expect(instance.computeFrameStyles()).toEqual(expectedFrameStyles);
    expect(instance.computeViewStyles()).toEqual(expectedViewStyles);
  })
});
