import * as React from 'react';
import { ExtensionFrame, Props as FrameProps } from '../extension-frame';
import { MobileOrientation } from '../../constants/mobile';
import { FrameSize } from '../../core/models/rig';

interface Props extends FrameProps {
  frameSize: FrameSize;
  orientation: string;
}

export class MobileView extends React.Component<Props> {
  public computeFrameStyles(): React.CSSProperties {
    const { frameSize, orientation } = this.props;
    const frameStyles: React.CSSProperties = { position: 'absolute' };
    if (orientation === MobileOrientation.Portrait) {
      const height = Math.floor(frameSize.height * 0.65);
      return {
        ...frameStyles,
        bottom: '0',
        height: `${height}px`,
        width: `${frameSize.width}px`,
      };
    } else {
      const width = Math.floor(frameSize.height * 0.28);
      return {
        ...frameStyles,
        height: `${frameSize.width}px`,
        right: '0',
        width: `${width}px`,
      };
    }
  }

  public computeViewStyles() {
    const { frameSize, orientation } = this.props;
    const viewStyles: React.CSSProperties = { background: '#322F37' };
    const height = orientation === MobileOrientation.Portrait ? frameSize.height : frameSize.width;
    const width = orientation === MobileOrientation.Portrait ? frameSize.width : frameSize.height;
    return {
      ...viewStyles,
      height: `${height}px`,
      width: `${width}px`,
    };
  }
  public render() {
    return (
      <div className="view" style={this.computeViewStyles()}>
        <div style={this.computeFrameStyles()}>
          <ExtensionFrame {...this.props} />
        </div>
      </div>
    );
  }
}
