import { setupShallowTest } from '../../tests/enzyme-util/shallow';
import { OverlayView } from '.';
import { createExtensionObjectForTest } from '../../tests/constants/extension';
import { ExtensionAnchor, ExtensionMode, ExtensionPlatform } from 'extension-coordinator';

const setupShallow = setupShallowTest(OverlayView, () => ({
  anchor: ExtensionAnchor.Overlay,
  channelId: 'channelId',
  displayChannelName: 'displayChannelName',
  extension: createExtensionObjectForTest(),
  frameSize: { width: 100, height: 100 },
  frameId: '1',
  installationAbilities: {
    isBitsEnabled: false,
    isChatEnabled: true,
    isSubscriptionStatusAvailable: false,
  },
  isExtensionVisible: true,
  isNonoVisible: true,
  isPopout: false,
  mode: ExtensionMode.Viewer,
  platform: ExtensionPlatform.Web,
  bindIframeToParent: jest.fn(),
}));

describe('<OverlayView />', () => {
  it('renders correctly', () => {
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
  });
});
