import * as React from 'react';
import { ExtensionFrame, Props as FrameProps } from '../extension-frame';
import { FrameSize } from '../../core/models/rig';
import classNames from 'classnames';

interface Props extends FrameProps {
  displayChannelName: string;
  frameSize: FrameSize;
  isExtensionVisible: boolean;
  isNonoVisible: boolean;
}

export class OverlayView extends React.Component<Props> {
  public render() {
    const { displayChannelName, frameSize, isExtensionVisible, isNonoVisible } = this.props;
    const viewClassNames = classNames('extension-view-selector__component', 'view', { 'nono-zone': isNonoVisible });
    const overlayClassNames = classNames('extension-view-selector__component-content', {
      'extension-view-selector__component-content--hidden': !isExtensionVisible,
    });
    const overlayStyles: React.CSSProperties = { height: `${frameSize.height}px`, width: `${frameSize.width}px` };
    const playerUrl = `/player?channel=${displayChannelName}&height=${frameSize.height}`;
    return (
      <div className={viewClassNames} style={overlayStyles}>
        {displayChannelName &&
          <webview src={playerUrl} style={{ height: `${frameSize.height + 4}px` }} title={displayChannelName} />}
        <div className={overlayClassNames}>
          <ExtensionFrame {...this.props} />
        </div>
      </div>
    );
  }
}
