import { setupShallowTest } from '../../tests/enzyme-util/shallow';
import { StandardView } from '.';
import { createExtensionObjectForTest } from '../../tests/constants/extension';
import { ExtensionAnchor, ExtensionMode, ExtensionPlatform } from 'extension-coordinator';

const setupShallow = setupShallowTest(StandardView, () => ({
  anchor: ExtensionAnchor.Panel,
  channelId: 'channelId',
  extension: createExtensionObjectForTest(),
  frameId: '1',
  hasBorder: true,
  installationAbilities: {
    isBitsEnabled: false,
    isChatEnabled: true,
    isSubscriptionStatusAvailable: false,
  },
  isPopout: false,
  mode: ExtensionMode.Viewer,
  platform: ExtensionPlatform.Web,
  type: ExtensionAnchor.Panel,
  bindIframeToParent: jest.fn(),
}));

describe('<StandardView />', () => {
  it('renders config correctly', () => {
    const { wrapper } = setupShallow({ type: ExtensionMode.Config });
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('renders dashboard correctly', () => {
    const { wrapper } = setupShallow({ type: ExtensionMode.Dashboard });
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('renders default panel correctly', () => {
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('renders non-default panel correctly', () => {
    const { wrapper } = setupShallow({ panelHeight: 333 });
    expect(wrapper.debug()).toMatchSnapshot();
  });
});
