import * as React from 'react';
import { ExtensionFrame, Props as FrameProps } from '../extension-frame';
import { ExtensionType } from '../../core/models/rig';
import { ExtensionMode } from 'extension-coordinator';
import classNames from 'classnames';

const configHeight = 700;
const configWidth = '100%';
const defaultPanelHeight = 300;
const minPanelHeight = 100;
const maxPanelHeight = 500;
const panelWidth = 320;

interface Props extends FrameProps {
  hasBorder: boolean;
  panelHeight?: number;
  type: ExtensionType;
}

export class StandardView extends React.Component<Props> {
  public render() {
    const { hasBorder, panelHeight, type } = this.props;
    const standardClassName = classNames('view', {
      'tw-border': hasBorder,
    });
    const height = computeHeight(type, panelHeight);
    const width = type === ExtensionMode.Config ? configWidth : `${panelWidth}px`;
    const standardStyles: React.CSSProperties = { height: `${height}px`, width };
    if (hasBorder) {
      standardStyles.boxSizing = 'content-box';
    }
    return (
      <div className={standardClassName} style={standardStyles}>
        <ExtensionFrame {...this.props} />
      </div>
    );
  }
}

function computeHeight(type: ExtensionType, panelHeight?: number): number {
  if (type === ExtensionMode.Config) {
    return configHeight;
  } else if (type !== ExtensionMode.Dashboard && panelHeight !== undefined) {
    return Math.min(Math.max(minPanelHeight, panelHeight), maxPanelHeight);
  }
  return defaultPanelHeight;
}
